/*:
 * @target MZ
 * @plugindesc クリックされた画面のピクセル座標(X, Y)を常に監視して指定した変数に格納します。@ChatGPT
 * @author ChatGPT
 *
 * @param variableIdX
 * @type variable
 * @text Xピクセル座標用変数ID
 * @desc クリックされたXピクセル座標を格納する変数ID
 *
 * @param variableIdY
 * @type variable
 * @text Yピクセル座標用変数ID
 * @desc クリックされたYピクセル座標を格納する変数ID
 *
 * @help
 * 【概要】
 * このプラグインはゲーム中常に動作し、
 * プレイヤーがクリックした画面上のピクセル座標を
 * 指定した変数に自動で格納します。
 *
 * - TouchInput.x → Xピクセル座標
 * - TouchInput.y → Yピクセル座標
 *
 * 【使い方】
 * プラグインパラメータで、X・Y用の変数IDを指定してください。
 *
 * 【備考】
 * - マップ画面中のみ動作します（タイトル画面やメニュー画面では無効）。
 */

(() => {
    const pluginName = "AutoClickScreenPosition";
    const parameters = PluginManager.parameters(pluginName);

    const variableIdX = Number(parameters["variableIdX"] || 0);
    const variableIdY = Number(parameters["variableIdY"] || 0);

    if (variableIdX > 0 && variableIdY > 0) {
        const _Scene_Map_update = Scene_Map.prototype.update;
        Scene_Map.prototype.update = function() {
            _Scene_Map_update.call(this);
            if (TouchInput.isTriggered()) {
                $gameVariables.setValue(variableIdX, TouchInput.x);
                $gameVariables.setValue(variableIdY, TouchInput.y);
            }
        };
    }
})();
